#include "InterfaceManager.h"

#define CHAT_MSG_SHOW_TIME 10.0f

InterfaceManager :: InterfaceManager() {
   owner = NULL;
}

InterfaceManager :: ~InterfaceManager() {
}

InterfaceManager* InterfaceManager :: instance() {
   static InterfaceManager *i = new InterfaceManager;
   return i;
}

void InterfaceManager :: init(UIOwner *owner) {

   this->owner = owner;
   uiman.setOwner(owner);
   uiman.init();
      
   //debugLabel = uiman.addLabel("debugLabel()",0.001f,0.999f);
   debugLabel = new MyUILabel("debugLabel()",0.001f,0.999f,0.999f,0.029f);
   uiman.addWidget(debugLabel);

   float shifty = -0.03f;
   creditsPanel = new MyUIPanel(0.62f,0.6f,0.25f,0.27f);
   creditsLabel[0] = new UILabel("Kasip kodlayan:",0.01f,-0.02f);
   creditsLabel[1] = new UILabel("M. Deniz Aydinoglu",0.03f,-0.02f + shifty);
   creditsLabel[2] = new UILabel("Niyeki?",0.01f,-0.02f + shifty * 2);
   creditsLabel[3] = new UILabel("nightshift'06",0.03f,-0.02f + shifty * 3);
   creditsLabel[4] = new UILabel("Nasil?",0.01f,-0.02f + shifty * 4);
   creditsLabel[5] = new UILabel("opengl+sdl+fmod",0.03f,-0.02f + shifty * 5);
   creditsLabel[6] = new UILabel("Materyal peki?",0.01f,-0.02f + shifty * 6);
   creditsLabel[7] = new UILabel("credits.txt",0.03f,-0.02f + shifty * 7);
   creditsLabel[1]->setColor(1,0,0);
   creditsLabel[3]->setColor(0.5f,0.5f,0);
   creditsLabel[5]->setColor(1,0,1);
   creditsLabel[7]->setColor(0.5f,0.5f,0);
   creditsPanel->addWidget(creditsLabel[0]);
   creditsPanel->addWidget(creditsLabel[1]);
   creditsPanel->addWidget(creditsLabel[2]);
   creditsPanel->addWidget(creditsLabel[3]);
   creditsPanel->addWidget(creditsLabel[4]);
   creditsPanel->addWidget(creditsLabel[5]);
   creditsPanel->addWidget(creditsLabel[6]);
   creditsPanel->addWidget(creditsLabel[7]);

   uiman.addWidget(creditsPanel);
   creditsPanel->setVisible(false);

   shifty = -0.03f;
   instPanel = new MyUIPanel(0.62f,0.6f,0.32f,0.27f);
   instLabel[0] = new UILabel("Kirmizi adam:",0.01f,-0.02f);
   instLabel[1] = new UILabel("ok tuslari + p",0.03f,-0.02f + shifty);
   instLabel[2] = new UILabel("Mavi adam:",0.01f,-0.02f + shifty * 2);
   instLabel[3] = new UILabel("w, s, a, d + space",0.03f,-0.02f + shifty * 3);
   instLabel[4] = new UILabel("Ayrica...",0.01f,-0.02f + shifty * 4);
   instLabel[5] = new UILabel("yukariya hizlica basinca ziplar",0.03f,-0.02f + shifty * 5);
   instLabel[6] = new UILabel("havada kombo ziplanabilir",0.03f,-0.02f + shifty * 6);
   instLabel[7] = new UILabel("arada sirada bonus cikar",0.03f,-0.02f + shifty * 7);
   instLabel[1]->setColor(1,0,0);
   instLabel[3]->setColor(1,0,0);
   instLabel[5]->setColor(1,0,0);
   instLabel[6]->setColor(1,0,0);
   instLabel[7]->setColor(1,0,0);
   instPanel->addWidget(instLabel[0]);
   instPanel->addWidget(instLabel[1]);
   instPanel->addWidget(instLabel[2]);
   instPanel->addWidget(instLabel[3]);
   instPanel->addWidget(instLabel[4]);
   instPanel->addWidget(instLabel[5]);
   instPanel->addWidget(instLabel[6]);
   instPanel->addWidget(instLabel[7]);

   uiman.addWidget(instPanel);
   instPanel->setVisible(false);

   float shiftup = 0.021f;
   mainMenu = new MyUIMenu("Ana Menu",0.40f,0.63f,0.22f,0.30f);
   uiman.addCustomMenu(mainMenu);
   mainMenu->addItem("Bombayla OldUr!",0.035f,-0.01f - shiftup);
   mainMenu->addItem("Roketle OldUr!",0.035f,-0.05f - shiftup);
   mainMenu->addItem("Harita Degistir",0.035f,-0.09f - shiftup);
   mainMenu->addItem("Nasi oynicam?",0.035f,-0.13f - shiftup);
   mainMenu->addItem("Kim yapti?",0.035f,-0.17f - shiftup);
   mainMenu->addItem("Cikis",0.035f,-0.21f - shiftup);

   chatLabel[0] = uiman.addLabel("host chat",0.0f,0.0f);
   chatLabel[1] = uiman.addLabel("peer chat",0.0f,0.0f);
   mapNameLabel = uiman.addLabel("[map.name]",0.8f,0.999f);

   chatLabel[0]->setColor(0,1,0);
   chatLabel[1]->setColor(1,0,0);

   oyorgLabel = uiman.addLabel("www.oyunyapimi.org",0.8f,0.97f);
   oyorgLabel->setColor(1,0,0);

   chatInputEdit = uiman.addEdit();
   chatInputEdit->setVisible(false);
   chatInputEdit->setPos(0.001f,0.979f);

   ipPanel = new MyUIPanel(0.3f,0.7f,0.25f,0.03f);
   ipEdit  = new UIEdit("127.0.0.1");
   ipEdit->setPos(0.06f,0);
   ipEdit->setColor(1,0.5f,0);
   ipEdit->setMaxChars(15);
   UILabel *l1 = new UILabel("Host:",0,0);
   ipPanel->addWidget(l1);
   ipPanel->addWidget(ipEdit);
   uiman.addWidget(ipPanel);
   ipPanel->setVisible(false);

   hostsPanel = new MyUIPanel(0.8f,0.17f,0.18f,0.03f*5);
   hostsLabel = new UIMultiLineLabel(" ** bulunamadi **",0,0);
   hostsPanel->addWidget(hostsLabel);
   hostsPanelCaption = new MyUILabel("Aktif Sunucular",0.8f,0.211f,0.18f,0.03f);
   //uiman.addWidget(hostsPanelCaption);
   //uiman.addWidget(hostsPanel);

   p1AmmoLabel = new UILabel("x 0",0.11f,0.05f);
   p2AmmoLabel = new UILabel("x 0",0.95f,0.05f);
   uiman.addWidget(p1AmmoLabel);
   uiman.addWidget(p2AmmoLabel);

   uiman.focusWidget(mainMenu);

}

void InterfaceManager :: debugMessage(const char *buffer) {
   debugLabel->setText(buffer);
}

void InterfaceManager :: toggleMainMenu() {
   if (mainMenu->isFocused()) {
      uiman.focusWidget(debugLabel);
      mainMenu->setVisible(false);
   }
   else {
      uiman.focusWidget(mainMenu);
      mainMenu->setVisible(true);
   }
}

void InterfaceManager :: showCreditsPanel(bool s) {
   if (s)
      uiman.focusWidget(creditsPanel);
   else
      uiman.focusWidget(debugLabel);
   creditsPanel->setVisible(s);
}

void InterfaceManager :: showInstPanel(bool s) {
   if (s)
      uiman.focusWidget(instPanel);
   else
      uiman.focusWidget(debugLabel);
   instPanel->setVisible(s);
}

void InterfaceManager :: activateMainMenu(bool a) {
   mainMenu->setVisible(a);
   if (a)
      uiman.focusWidget(mainMenu);
   else
      uiman.focusWidget(debugLabel);
}

void InterfaceManager :: showIpPanel(bool s) {
   if (s)
      uiman.focusWidget(ipPanel);
   else
      uiman.focusWidget(debugLabel);
   ipPanel->setVisible(s);
}

void InterfaceManager :: setHosts(list<string> &hosts) {   
   
   static char buffer[100*64];
   char *ptr = buffer;
   
   list<string>::iterator i = hosts.begin();
   while (i != hosts.end()) {
      string &s = *i;
      int slen = s.length();
      memcpy(ptr,s.c_str(),slen);
      ptr[slen] = 10;
      ptr += (slen+1);
      ++i;
   }

   hostsLabel->setText(buffer);

}

void InterfaceManager :: setAmmo(int p1a,int p2a) {

   char str[16];

   sprintf(str,"x %d",p1a);
   p1AmmoLabel->setText(str);
   sprintf(str,"x %d",p2a);
   p2AmmoLabel->setText(str);

}

void InterfaceManager :: updateScores(int p1scr,int p2scr) {
}

void InterfaceManager :: updateChatMessages(float x1,float y1,const char *p1msg,
                                            float x2,float y2,const char *p2msg) {
   
   if (strcmp(chatLabel[0]->getText(),p1msg) != 0) {
      chatTimeout[0] = CHAT_MSG_SHOW_TIME;
      chatLabel[0]->setText(p1msg);
      chatLabel[0]->setVisible(true);
   }
   if (strcmp(chatLabel[1]->getText(),p2msg) != 0) {
      chatTimeout[1] = CHAT_MSG_SHOW_TIME;
      chatLabel[1]->setText(p2msg);
      chatLabel[1]->setVisible(true);
   }
   
   chatLabel[0]->setPos(x1*0.1f*0.5f,y1*0.1f*0.5f);
   chatLabel[1]->setPos(x2*0.1f*0.5f,y2*0.1f*0.5f);
}

void InterfaceManager :: beginChatText() {
   chatInputEdit->setText("> ");
   chatInputEdit->setVisible(true);
   uiman.focusWidget(chatInputEdit);
}

void InterfaceManager :: endChatText() {
   chatInputEdit->resetEnter();
   chatInputEdit->setVisible(false);
   uiman.focusWidget(debugLabel);
   strncpy(chatText,chatInputEdit->getText(),256);
}

void InterfaceManager :: processKeyEvents(const SDLKey &key) {
   uiman.keyEvent(key);
}

void InterfaceManager :: update(float dt) {
   uiman.update(dt);

   for (int i=0;i<2;++i) {
      chatTimeout[i] -= dt;
      if (chatTimeout[i] < 0) {
         chatLabel[i]->setVisible(false);
      }
   }

}

void InterfaceManager :: render() {
   uiman.render();
}

